// Copyright 1994 by Jon Dart.
// arasan.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "arasan.h"

#include "mainfrm.h"
#include "arasadoc.h"
#include "arasavw.h"
#include "globals.h"
#include "afxpriv.h" // for CRecentFileList
#include "constant.h"
#include <ctype.h>
#include <string.h>
#include <fstream.h>
#include <strstrea.h>
                                                                                    
                                                                                    
CArasanView *theView;
char initialFilename[MAX_PATH];
char *programPath;

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

//////////////////////////////////////////////////////////////////////////////
// CArasanApp

BEGIN_MESSAGE_MAP(CArasanApp, CWinApp)
        //{{AFX_MSG_MAP(CArasanApp)
                // NOTE - the ClassWizard will add and remove mapping macros here.
                //    DO NOT EDIT what you see in these blocks of generated code!
        //}}AFX_MSG_MAP
        // Standard file based document commands
        ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
        ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
        // Standard print setup command
        ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

static CArasanView *view = NULL;

/////////////////////////////////////////////////////////////////////////////
// CArasanApp construction

CArasanApp::CArasanApp()
: CWinApp("Arasan " Arasan_Version)
{
     // TODO: add construction code here,
     // Place all significant initialization in InitInstance
}

CArasanApp::~CArasanApp()
{
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CArasanApp object

CArasanApp NEAR theApp;

/////////////////////////////////////////////////////////////////////////////
// CArasanApp initialization

BOOL CArasanApp::InitInstance()
{
        // Set the registry key.  This makes MFC store option data in
        // the Registry rather than in an .INI file.  Normally this
        // key is a company name - we don't have one, we use "Arasan".
        SetRegistryKey("Arasan");
        
        // Standard initialization
        // If you are not using these features and wish to reduce the size
        //  of your final executable, you should remove from the following
        //  the specific initialization routines you do not need.

        SetDialogBkColor();        // Set dialog background color to gray
        LoadStdProfileSettings();  // Load standard INI file options (including MRU)

        // Register the application's document templates.  Document templates
        //  serve as the connection between documents, frame windows and views.

        CSingleDocTemplate* pDocTemplate;
        pDocTemplate = new CSingleDocTemplate(
                              IDR_MAINFRAME,
                              RUNTIME_CLASS(CArasanDoc),
                              RUNTIME_CLASS(CMainFrame),
                              RUNTIME_CLASS(CArasanView));
        AddDocTemplate(pDocTemplate);

        programPath = new char[MAX_PATH];
		// initialize this before we create our view class
        global_options = new Options(this);
                                              
        // create a new (empty) document
        OnFileNew();
        
        POSITION pos = pDocTemplate->GetFirstDocPosition();
        ASSERT(pos);
        CDocument* firstDoc = pDocTemplate->GetNextDoc(pos);
        ASSERT(firstDoc);
        pos = firstDoc->GetFirstViewPosition();
        ASSERT(pos);
        theView = (CArasanView*)firstDoc->GetNextView(pos);
        ASSERT(theView);
        *initialFilename = '\0';
        if (m_lpCmdLine[0] != '\0')
        {
            // command-line processing.
            int i = 0;
            // skip leading blanks, if any:
            while (m_lpCmdLine[i] != '\0' &&
                   isspace(m_lpCmdLine[i])) ++i;
            int j = i;
            while (m_lpCmdLine[j] != '\0' &&
                   !isspace(m_lpCmdLine[j])) ++j;
            m_lpCmdLine[j] = '\0'; // remove trailing blanks, if any
            strncpy(initialFilename,m_lpCmdLine+i,MAX_PATH);
        }
        return TRUE;
}

int CArasanApp::ExitInstance()
{
    // We cannot delete the options in the destructor, because they
    // depend on the CWinApp instance we're destroying.  So do it here:
    delete global_options;
	delete programPath;
    return CWinApp::ExitInstance();
}

BOOL CArasanApp::OnRecentFile(UINT nID)
{ 
#if _MFC_VER >= 0x300
        theView->open_file((*m_pRecentFileList)[nID - ID_FILE_MRU_FILE1]);
        return TRUE; // We processed this message
#else
        return FALSE;
#endif
      
}
